/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_776;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.book.structure.StructureInfo;
import slimeknights.mantle.client.book.structure.level.TemplateLevel;
import slimeknights.mantle.client.render.MantleRenderTypes;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class StructureElement
extends SizedBookElement {
    public boolean canTick = false;
    public float scale = 50.0f;
    public float transX = 0.0f;
    public float transY = 0.0f;
    public class_4590 additionalTransform;
    public final StructureInfo renderInfo;
    public final TemplateLevel structureWorld;
    public long lastStep = -1L;
    public long lastPrintedErrorTimeMs = -1L;

    public StructureElement(int x, int y, int width, int height, class_3499 template, List<class_3499.class_3501> structure) {
        super(x, y, width, height);
        int[] size = new int[]{template.method_15160().method_10263(), template.method_15160().method_10264(), template.method_15160().method_10260()};
        this.scale = 100.0f / (float)IntStream.of(size).max().getAsInt();
        float sx = (float)width / 182.0f;
        float sy = (float)height / 176.0f;
        this.scale *= Math.min(sx, sy);
        this.renderInfo = new StructureInfo(structure);
        this.structureWorld = new TemplateLevel(structure, this.renderInfo);
        this.transX = (float)x + (float)width / 2.0f;
        this.transY = (float)y + (float)height / 2.0f;
        this.additionalTransform = new class_4590(null, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, 0.0f), null, new Quaternionf().rotationXYZ(0.0f, -0.7853982f, 0.0f));
    }

    @Override
    public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, class_327 fontRenderer) {
        class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_4587 transform = guiGraphics.method_51448();
        class_4587.class_4665 lastEntryBeforeTry = transform.method_23760();
        try {
            long currentTime = System.currentTimeMillis();
            if (this.lastStep < 0L) {
                this.lastStep = currentTime;
            } else if (this.canTick && currentTime - this.lastStep > 200L) {
                this.renderInfo.step();
                this.lastStep = currentTime;
            }
            if (!this.canTick) {
                this.renderInfo.reset();
            }
            int structureLength = this.renderInfo.structureLength;
            int structureWidth = this.renderInfo.structureWidth;
            int structureHeight = this.renderInfo.structureHeight;
            transform.method_22903();
            class_776 blockRender = class_310.method_1551().method_1541();
            transform.method_46416(this.transX, this.transY, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
            transform.method_22905(this.scale, -this.scale, 1.0f);
            transform.pushTransformation(this.additionalTransform);
            transform.method_22907(new Quaternionf());
            transform.method_46416((float)structureLength / -2.0f, (float)structureHeight / -2.0f, (float)structureWidth / -2.0f);
            for (int h = 0; h < structureHeight; ++h) {
                for (int l = 0; l < structureLength; ++l) {
                    for (int w = 0; w < structureWidth; ++w) {
                        class_2338 pos = new class_2338(l, h, w);
                        class_2680 state = this.structureWorld.method_8320(pos);
                        if (state.method_26215()) continue;
                        transform.method_22903();
                        transform.method_46416((float)l, (float)h, (float)w);
                        int overlay = pos.equals((Object)new class_2338(1, 1, 1)) ? class_4608.method_23624((float)0.0f, (boolean)true) : class_4608.field_21444;
                        blockRender.method_3350().method_3374((class_1920)this.structureWorld, blockRender.method_3349(state), state, pos, transform, buffer.getBuffer(MantleRenderTypes.TRANSLUCENT_FULLBRIGHT), false, this.structureWorld.field_9229, state.method_26190(pos), overlay);
                        transform.method_22909();
                    }
                }
            }
            transform.method_22909();
            transform.method_22909();
        }
        catch (Exception e) {
            long now = System.currentTimeMillis();
            if (now > this.lastPrintedErrorTimeMs + 1000L) {
                e.printStackTrace();
                this.lastPrintedErrorTimeMs = now;
            }
            while (lastEntryBeforeTry != transform.method_23760()) {
                transform.method_22909();
            }
        }
        buffer.method_22993();
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDragged(double clickX, double clickY, double mouseX, double mouseY, double lastX, double lastY, int button) {
        double dx = mouseX - lastX;
        double dy = mouseY - lastY;
        this.additionalTransform = this.forRotation(dx * 80.0 / 104.0, dy * 0.8).method_22933(this.additionalTransform);
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int clickedMouseButton) {
        super.mouseReleased(mouseX, mouseY, clickedMouseButton);
    }

    private class_4590 forRotation(double rX, double rY) {
        Vector3f axis = new Vector3f((float)rY, (float)rX, 0.0f);
        float angle = (float)Math.sqrt(axis.dot((Vector3fc)axis));
        axis.normalize();
        return new class_4590(null, new Quaternionf().setAngleAxis(angle, axis.x(), axis.y(), axis.z()), null, null);
    }
}

